/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.item;

import java.util.List;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.ItemExtension;
import org.mtr.mod.generated.lang.TranslationProvider;

public abstract class ItemDriverKey
extends ItemExtension {
    public final boolean canDrive;
    public final boolean canOpenDoors;
    public final boolean canBoardAnyVehicle;
    public final int color;

    public ItemDriverKey(ItemSettings itemSettings, boolean canDrive, boolean canOpenDoors, boolean canBoardAnyVehicle, int color) {
        super(itemSettings.maxCount(1));
        this.canDrive = canDrive;
        this.canOpenDoors = canOpenDoors;
        this.canBoardAnyVehicle = canBoardAnyVehicle;
        this.color = color;
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable World world, List<MutableText> tooltip, TooltipContext options) {
        if (this.canBoardAnyVehicle) {
            tooltip.add(TranslationProvider.TOOLTIP_MTR_CAN_BOARD_ANY_VEHICLE_TRUE.getMutableText(new Object[0]).formatted(TextFormatting.GOLD));
        }
        tooltip.add((this.canDrive ? TranslationProvider.TOOLTIP_MTR_CAN_DRIVE_TRUE : TranslationProvider.TOOLTIP_MTR_CAN_DRIVE_FALSE).getMutableText(new Object[0]).formatted(this.canDrive ? TextFormatting.GRAY : TextFormatting.DARK_GRAY));
        tooltip.add((this.canOpenDoors ? TranslationProvider.TOOLTIP_MTR_CAN_OPEN_DOORS_TRUE : TranslationProvider.TOOLTIP_MTR_CAN_OPEN_DOORS_FALSE).getMutableText(new Object[0]).formatted(this.canOpenDoors ? TextFormatting.GRAY : TextFormatting.DARK_GRAY));
    }
}

