/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.item;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.mtr.core.data.Rail;
import org.mtr.core.data.TransportMode;
import org.mtr.core.data.TwoPositionsBase;
import org.mtr.core.operation.RailsRequest;
import org.mtr.core.operation.RailsResponse;
import org.mtr.core.tool.Angle;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockNode;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.item.ItemBlockClickingBase;

public abstract class ItemNodeModifierBase
extends ItemBlockClickingBase {
    public final boolean forNonContinuousMovementNode;
    public final boolean forContinuousMovementNode;
    public final boolean forAirplaneNode;
    protected final boolean isConnector;
    private static final String TAG_TRANSPORT_MODE = "transport_mode";

    public ItemNodeModifierBase(boolean forNonContinuousMovementNode, boolean forContinuousMovementNode, boolean forAirplaneNode, boolean isConnector, ItemSettings itemSettings) {
        super(itemSettings.maxCount(1));
        this.forNonContinuousMovementNode = forNonContinuousMovementNode;
        this.forContinuousMovementNode = forContinuousMovementNode;
        this.forAirplaneNode = forAirplaneNode;
        this.isConnector = isConnector;
    }

    @Override
    protected void onStartClick(ItemUsageContext context, CompoundTag compoundTag) {
        compoundTag.putString(TAG_TRANSPORT_MODE, ((BlockNode)context.getWorld().getBlockState((BlockPos)context.getBlockPos()).getBlock().data).transportMode.toString());
    }

    @Override
    protected void onEndClick(ItemUsageContext context, BlockPos posEnd, CompoundTag compoundTag) {
        World world = context.getWorld();
        BlockPos posStart = context.getBlockPos();
        BlockState stateStart = world.getBlockState(posStart);
        Block blockStart = stateStart.getBlock();
        BlockState stateEnd = world.getBlockState(posEnd);
        PlayerEntity player = context.getPlayer();
        if (ServerPlayerEntity.isInstance(player) && stateEnd.getBlock().data instanceof BlockNode && ((BlockNode)blockStart.data).transportMode.toString().equals(compoundTag.getString(TAG_TRANSPORT_MODE))) {
            if (this.isConnector) {
                if (!posStart.equals(posEnd)) {
                    ObjectObjectImmutablePair<Angle, Angle> angles = Rail.getAngles(Init.blockPosToPosition(posStart), BlockNode.getAngle(stateStart), Init.blockPosToPosition(posEnd), BlockNode.getAngle(stateEnd));
                    this.onConnect(world, context.getStack(), ((BlockNode)blockStart.data).transportMode, stateStart, stateEnd, posStart, posEnd, angles.left(), angles.right(), ServerPlayerEntity.cast(player));
                }
            } else {
                this.onRemove(world, posStart, posEnd, ServerPlayerEntity.cast(player));
            }
        }
        compoundTag.remove(TAG_TRANSPORT_MODE);
    }

    @Override
    protected boolean clickCondition(ItemUsageContext context) {
        World world = context.getWorld();
        Block blockStart = world.getBlockState(context.getBlockPos()).getBlock();
        if (blockStart.data instanceof BlockNode) {
            BlockNode blockNode = (BlockNode)blockStart.data;
            if (blockNode.transportMode == TransportMode.AIRPLANE) {
                return this.forAirplaneNode;
            }
            return blockNode.transportMode.continuousMovement ? this.forContinuousMovementNode : this.forNonContinuousMovementNode;
        }
        return false;
    }

    protected abstract void onConnect(World var1, ItemStack var2, TransportMode var3, BlockState var4, BlockState var5, BlockPos var6, BlockPos var7, Angle var8, Angle var9, @Nullable ServerPlayerEntity var10);

    protected abstract void onRemove(World var1, BlockPos var2, BlockPos var3, @Nullable ServerPlayerEntity var4);

    public static void getRail(World world, BlockPos blockPos1, BlockPos blockPos2, @Nullable ServerPlayerEntity serverPlayerEntity, Consumer<Rail> consumer) {
        Init.sendMessageC2S("rails", world.getServer(), world, new RailsRequest().addRailId(TwoPositionsBase.getHexId(Init.blockPosToPosition(blockPos1), Init.blockPosToPosition(blockPos2))), railsResponse -> {
            ObjectImmutableList<Rail> rails = railsResponse.getRails();
            if (rails.isEmpty()) {
                if (serverPlayerEntity != null) {
                    serverPlayerEntity.sendMessage(TranslationProvider.GUI_MTR_RAIL_NOT_FOUND_ACTION.getText(new Object[0]), true);
                }
            } else {
                consumer.accept(rails.get(0));
            }
        }, RailsResponse.class);
    }

    public static TransportMode getTransportMode(CompoundTag compoundTag) {
        return EnumHelper.valueOf(TransportMode.TRAIN, compoundTag.getString(TAG_TRANSPORT_MODE));
    }
}

