/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import java.util.Random;
import java.util.stream.Collectors;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;
import org.mtr.mod.data.ArrivalsCacheServer;

public final class PacketFetchArrivals
extends PacketHandler {
    private final LongAVLTreeSet platformIds;
    private final long responseTime;
    private final ObjectArrayList<String> responses = new ObjectArrayList();
    private final long callbackId;
    private static final Long2ObjectAVLTreeMap<Callback> CALLBACKS = new Long2ObjectAVLTreeMap();

    public PacketFetchArrivals(PacketBufferReceiver packetBufferReceiver) {
        this.platformIds = new LongAVLTreeSet();
        int platformIdCount = packetBufferReceiver.readInt();
        for (int i = 0; i < platformIdCount; ++i) {
            this.platformIds.add(packetBufferReceiver.readLong());
        }
        this.responseTime = packetBufferReceiver.readLong();
        int responseCount = packetBufferReceiver.readInt();
        for (int i = 0; i < responseCount; ++i) {
            this.responses.add(packetBufferReceiver.readString());
        }
        this.callbackId = packetBufferReceiver.readLong();
    }

    public PacketFetchArrivals(LongAVLTreeSet platformIds, Callback callback) {
        this.platformIds = platformIds;
        this.responseTime = 0L;
        this.callbackId = new Random().nextLong();
        CALLBACKS.put(this.callbackId, callback);
    }

    private PacketFetchArrivals(long responseTime, ObjectArrayList<ArrivalResponse> arrivalResponses, long callbackId) {
        this.platformIds = new LongAVLTreeSet();
        this.responseTime = responseTime;
        arrivalResponses.forEach(arrivalResponse -> this.responses.add(Utilities.getJsonObjectFromData(arrivalResponse).toString()));
        this.callbackId = callbackId;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeInt(this.platformIds.size());
        this.platformIds.forEach(packetBufferSender::writeLong);
        packetBufferSender.writeLong(this.responseTime);
        packetBufferSender.writeInt(this.responses.size());
        this.responses.forEach(packetBufferSender::writeString);
        packetBufferSender.writeLong(this.callbackId);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        ArrivalsCacheServer instance = ArrivalsCacheServer.getInstance(serverPlayerEntity.getServerWorld());
        Init.REGISTRY.sendPacketToClient(serverPlayerEntity, new PacketFetchArrivals(instance.getMillisOffset() + System.currentTimeMillis(), instance.requestArrivals(this.platformIds), this.callbackId));
    }

    @Override
    public void runClient() {
        Callback callback = CALLBACKS.remove(this.callbackId);
        if (callback != null) {
            callback.accept(this.responseTime, this.responses.stream().map(response -> new ArrivalResponse(new JsonReader(Utilities.parseJson(response)))).collect(Collectors.toCollection(ObjectArrayList::new)));
        }
    }

    @FunctionalInterface
    public static interface Callback {
        public void accept(long var1, ObjectList<ArrivalResponse> var3);
    }
}

