/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import javax.annotation.Nonnull;
import org.mtr.core.data.TransportMode;
import org.mtr.core.operation.ListDataResponse;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.packet.ClientPacketHelper;
import org.mtr.mod.packet.PacketRequestResponseBase;

public final class PacketOpenDashboardScreen
extends PacketRequestResponseBase {
    private final TransportMode transportMode;
    private final ScreenType screenType;
    private final long dataId;

    public PacketOpenDashboardScreen(PacketBufferReceiver packetBufferReceiver) {
        super(packetBufferReceiver);
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packetBufferReceiver.readString());
        this.screenType = EnumHelper.valueOf(ScreenType.DEFAULT, packetBufferReceiver.readString());
        this.dataId = packetBufferReceiver.readLong();
    }

    private PacketOpenDashboardScreen(String content, TransportMode transportMode) {
        super(content);
        this.transportMode = transportMode;
        this.screenType = ScreenType.DEFAULT;
        this.dataId = 0L;
    }

    private PacketOpenDashboardScreen(String content, TransportMode transportMode, ScreenType screenType, long dataId) {
        super(content);
        this.transportMode = transportMode;
        this.screenType = screenType;
        this.dataId = dataId;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        super.write(packetBufferSender);
        packetBufferSender.writeString(this.transportMode.toString());
        packetBufferSender.writeString(this.screenType.toString());
        packetBufferSender.writeLong(this.dataId);
    }

    @Override
    protected void runClientInbound(JsonReader jsonReader) {
        new ListDataResponse(jsonReader, MinecraftClientData.getDashboardInstance()).write();
        ClientPacketHelper.openDashboardScreen(this.transportMode, this.screenType, this.dataId);
    }

    @Override
    protected PacketRequestResponseBase getInstance(String content) {
        return new PacketOpenDashboardScreen(content, this.transportMode, this.screenType, this.dataId);
    }

    @Override
    protected SerializedDataBase getDataInstance(JsonReader jsonReader) {
        return new SerializedDataBase(){

            @Override
            public void updateData(ReaderBase readerBase) {
            }

            @Override
            public void serializeData(WriterBase writerBase) {
            }
        };
    }

    @Override
    @Nonnull
    protected String getKey() {
        return "list_data";
    }

    @Override
    protected PacketRequestResponseBase.ResponseType responseType() {
        return PacketRequestResponseBase.ResponseType.PLAYER;
    }

    public static void sendDirectlyToServer(ServerWorld serverWorld, ServerPlayerEntity serverPlayerEntity, TransportMode transportMode) {
        new PacketOpenDashboardScreen(new JsonObject().toString(), transportMode).runServerOutbound(serverWorld, serverPlayerEntity);
    }

    public static void sendDirectlyToServer(ServerWorld serverWorld, ServerPlayerEntity serverPlayerEntity, TransportMode transportMode, ScreenType screenType, long id) {
        new PacketOpenDashboardScreen(new JsonObject().toString(), transportMode, screenType, id).runServerOutbound(serverWorld, serverPlayerEntity);
    }

    public static enum ScreenType {
        DEFAULT,
        STATION,
        PLATFORM,
        DEPOT,
        SIDING;

    }
}

