/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import org.mtr.core.tool.Utilities;

public enum DoorAnimationType {
    STANDARD,
    STANDARD_SLOW,
    CONSTANT,
    PLUG_FAST,
    PLUG_SLOW,
    PLUG_SLOW_2,
    PLUG_SLOW_3,
    BOUNCY_1,
    BOUNCY_2,
    MLR,
    R179,
    R211;


    public double getDoorAnimationX(double multiplier, boolean flipped, double time) {
        return multiplier == 0.0 ? 0.0 : Math.copySign(this.getDoorAnimationXAbsolute(Math.abs(multiplier), time), (double)(flipped ? -1 : 1) * multiplier);
    }

    public double getDoorAnimationZ(double multiplier, boolean flipped, double time, boolean opening) {
        return multiplier == 0.0 ? 0.0 : Math.copySign(this.getDoorAnimationZAbsolute(Math.abs(multiplier), time, opening), (double)(flipped ? -1 : 1) * multiplier);
    }

    private double getDoorAnimationXAbsolute(double multiplier, double time) {
        switch (this) {
            case PLUG_FAST: 
            case PLUG_SLOW_2: 
            case PLUG_SLOW_3: {
                return time < 0.05 ? time * 20.0 * multiplier + 0.05 : multiplier + 0.05;
            }
            case PLUG_SLOW: {
                return DoorAnimationType.smoothEnds(0.05, multiplier + 0.05, 0.0, 0.1, time);
            }
        }
        return 0.0;
    }

    private double getDoorAnimationZAbsolute(double doorMax, double time, boolean opening) {
        switch (this) {
            case CONSTANT: {
                return doorMax * Utilities.clamp(time / 0.5, 0.0, 1.0);
            }
            case PLUG_FAST: {
                return DoorAnimationType.smoothEnds(-doorMax, doorMax, -0.5, 0.5, time);
            }
            case PLUG_SLOW: {
                if (opening) {
                    return DoorAnimationType.smoothEnds(0.0, doorMax, 0.05, 0.5, time);
                }
                if (time > 0.5) {
                    return DoorAnimationType.smoothEnds(2.0, doorMax, 0.5, 1.0, time);
                }
                if (time < 0.3) {
                    return DoorAnimationType.smoothEnds(0.0, 2.0, 0.05, 0.3, time);
                }
                return 2.0;
            }
            case PLUG_SLOW_2: {
                return DoorAnimationType.smoothEnds(-doorMax, doorMax, -0.75, 0.75, time);
            }
            case PLUG_SLOW_3: {
                return DoorAnimationType.smoothEnds(-doorMax, doorMax, -1.0, 1.0, time);
            }
            case BOUNCY_1: {
                if (opening) {
                    if (time > 0.4) {
                        return DoorAnimationType.smoothEnds(doorMax - 1.0, doorMax - 0.5, 0.4, 0.5, time);
                    }
                    return DoorAnimationType.smoothEnds(-doorMax + 1.0, doorMax - 1.0, -0.4, 0.4, time);
                }
                if (time > 0.2) {
                    return DoorAnimationType.smoothEnds(1.0, doorMax - 0.5, 0.2, 0.5, time);
                }
                if (time > 0.1) {
                    return DoorAnimationType.smoothEnds(1.5, 1.0, 0.1, 0.2, time);
                }
                return DoorAnimationType.smoothEnds(-1.5, 1.5, -0.1, 0.1, time);
            }
            case BOUNCY_2: {
                if (opening) {
                    if (time > 0.4) {
                        return DoorAnimationType.smoothEnds(doorMax - 0.5, doorMax, 0.4, 0.5, time);
                    }
                    return DoorAnimationType.smoothEnds(-doorMax + 0.5, doorMax - 0.5, -0.4, 0.4, time);
                }
                if (time > 0.3) {
                    return DoorAnimationType.smoothEnds(1.0, doorMax, 0.3, 0.5, time);
                }
                if (time > 0.1) {
                    return DoorAnimationType.smoothEnds(3.0, 1.0, 0.1, 0.3, time);
                }
                return DoorAnimationType.smoothEnds(-3.0, 3.0, -0.1, 0.1, time);
            }
            case MLR: {
                if (opening) {
                    if (time < 0.2) {
                        return 0.0;
                    }
                    if (time > 0.7) {
                        return doorMax;
                    }
                    return (time - 0.2) * 2.0 * doorMax;
                }
                double stoppingPoint = 1.5;
                if (time > 0.25) {
                    return Math.min((time - 0.25) * 2.0 * doorMax + 1.5 + 1.0, doorMax);
                }
                if (time > 0.2) {
                    return DoorAnimationType.smoothEnds(1.5, 3.5, 0.2, 0.3, time);
                }
                if (time < 0.1) {
                    return time / 0.1 * 1.5;
                }
                return 1.5;
            }
            case R179: {
                if (opening) {
                    if (time > 0.4) {
                        return DoorAnimationType.smoothEnds(doorMax - 1.0, doorMax - 0.5, 0.4, 0.6, time);
                    }
                    return DoorAnimationType.smoothEnds(-doorMax + 1.0, doorMax - 1.0, -0.4, 0.4, time);
                }
                if (time > 0.2) {
                    return DoorAnimationType.smoothEnds(1.0, doorMax - 0.5, 0.2, 0.6, time);
                }
                return DoorAnimationType.smoothEnds(-1.5, 1.5, -0.4, 0.4, time);
            }
            case R211: {
                if (time < 0.2) {
                    return 0.0;
                }
                if (time > 0.7) {
                    return doorMax;
                }
                return (time - 0.2) * 2.0 * doorMax;
            }
            case STANDARD_SLOW: {
                if (opening) break;
                if (time > 0.2) {
                    return DoorAnimationType.smoothEnds(1.0, doorMax, 0.2, 0.5, time);
                }
                if (time > 0.1) {
                    return 1.0;
                }
                return DoorAnimationType.smoothEnds(0.0, 1.0, 0.0, 0.1, time);
            }
        }
        return DoorAnimationType.smoothEnds(0.0, doorMax, 0.0, 0.5, time);
    }

    private static double smoothEnds(double startValue, double endValue, double startTime, double endTime, double time) {
        if (time < startTime) {
            return startValue;
        }
        if (time > endTime) {
            return endValue;
        }
        double timeChange = endTime - startTime;
        double valueChange = endValue - startValue;
        return valueChange * (1.0 - Math.cos(Math.PI * (time - startTime) / timeChange)) / 2.0 + startValue;
    }
}

