/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import javax.annotation.Nullable;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.config.Config;
import org.mtr.mod.generated.resource.ObjectResourceSchema;
import org.mtr.mod.render.DynamicVehicleModel;
import org.mtr.mod.resource.CachedResource;
import org.mtr.mod.resource.CustomResourceTools;
import org.mtr.mod.resource.OptimizedModelWrapper;
import org.mtr.mod.resource.ResourceProvider;
import org.mtr.mod.resource.StoredModelResourceBase;

public final class ObjectResource
extends ObjectResourceSchema
implements StoredModelResourceBase {
    public final boolean shouldPreload;
    private final CachedResource<ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel>> cachedObjectResource;

    public ObjectResource(ReaderBase readerBase, ResourceProvider resourceProvider) {
        super(readerBase, resourceProvider);
        this.updateData(readerBase);
        this.shouldPreload = Config.getClient().matchesPreloadResourcePattern(this.id);
        this.cachedObjectResource = new CachedResource<ObjectObjectImmutablePair>(() -> this.load(this.modelResource, this.textureResource, this.flipTextureV, 0.0, resourceProvider), this.shouldPreload ? Integer.MAX_VALUE : 60000L);
    }

    @Override
    @Nullable
    public OptimizedModelWrapper getOptimizedModel() {
        ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel> railResource = this.cachedObjectResource.getData(false);
        return railResource == null ? null : railResource.left();
    }

    @Override
    @Nullable
    public DynamicVehicleModel getDynamicVehicleModel() {
        ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel> railResource = this.cachedObjectResource.getData(false);
        return railResource == null ? null : railResource.right();
    }

    @Override
    public void transform(ObjectCollection<OptimizedModel.ObjModel> values2) {
        values2.forEach(objModel -> {
            objModel.applyTranslation(this.translation.getX(), this.translation.getY(), this.translation.getZ());
            objModel.applyRotation(this.rotation.getX(), this.rotation.getY(), this.rotation.getZ());
            objModel.applyScale(ObjectResource.clampNumber(this.scale.getX()), ObjectResource.clampNumber(this.scale.getY()), ObjectResource.clampNumber(this.scale.getZ()));
            objModel.applyMirror(this.mirror.getX(), this.mirror.getY(), this.mirror.getZ());
        });
    }

    @Override
    public void preload() {
        this.cachedObjectResource.getData(true);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return TextHelper.translatable(this.name, new Object[0]).getString();
    }

    public int getColor() {
        return CustomResourceTools.colorStringToInt(this.color);
    }

    private static double clampNumber(double value) {
        return value <= 0.0 ? 1.0 : value;
    }
}

