/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongIterator;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.screen.DashboardList;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.MTRScreenBase;

public class DashboardListSelectorScreen
extends MTRScreenBase
implements IGui {
    protected final ObjectImmutableList<DashboardListItem> allData;
    protected final LongCollection selectedIds;
    protected final DashboardList availableList;
    protected final DashboardList selectedList;
    protected final ButtonWidgetExtension buttonDone;
    private final Runnable onClose;
    private final boolean isSingleSelect;
    private final boolean canRepeat;

    public DashboardListSelectorScreen(ObjectImmutableList<DashboardListItem> allData, LongCollection selectedIds, boolean isSingleSelect, boolean canRepeat, @Nullable ScreenExtension previousScreenExtension) {
        this(null, allData, selectedIds, isSingleSelect, canRepeat, previousScreenExtension);
    }

    public DashboardListSelectorScreen(@Nullable Runnable onClose, ObjectImmutableList<DashboardListItem> allData, LongCollection selectedIds, boolean isSingleSelect, boolean canRepeat, @Nullable ScreenExtension previousScreenExtension) {
        super(previousScreenExtension);
        this.onClose = onClose;
        this.allData = allData;
        this.selectedIds = selectedIds;
        this.isSingleSelect = isSingleSelect;
        this.canRepeat = canRepeat;
        this.availableList = new DashboardList(null, null, null, null, this::onAdd, null, null, () -> MinecraftClientData.ROUTES_PLATFORMS_SEARCH, text -> {
            MinecraftClientData.ROUTES_PLATFORMS_SEARCH = text;
        });
        this.selectedList = new DashboardList(null, null, null, this::updateList, null, this::onDelete, () -> selectedIds instanceof LongList ? (LongList)selectedIds : new LongArrayList(), () -> MinecraftClientData.ROUTES_PLATFORMS_SELECTED_SEARCH, text -> {
            MinecraftClientData.ROUTES_PLATFORMS_SELECTED_SEARCH = text;
        });
        this.buttonDone = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.done", new Object[0]), button -> this.onClose2());
    }

    @Override
    protected void init2() {
        super.init2();
        this.availableList.x = this.f_96543_ / 2 - 144 - 20;
        this.selectedList.x = this.f_96543_ / 2 + 20;
        this.selectedList.y = 34;
        this.availableList.y = 34;
        this.availableList.height = this.selectedList.height = this.f_96544_ - 100 + 6;
        this.selectedList.width = 144;
        this.availableList.width = 144;
        this.availableList.init(this::addChild);
        this.selectedList.init(this::addChild);
        IDrawing.setPositionAndWidth(this.buttonDone, (this.f_96543_ - 144) / 2, this.f_96544_ - 40, 144);
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonDone));
        this.updateList();
    }

    @Override
    public void tick2() {
        this.availableList.tick();
        this.selectedList.tick();
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        this.availableList.render(graphicsHolder);
        this.selectedList.render(graphicsHolder, false);
        super.render(graphicsHolder, mouseX, mouseY, delta);
        this.renderAdditional(graphicsHolder, mouseX, mouseY, delta);
    }

    public void renderAdditional(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        graphicsHolder.drawCenteredText(TranslationProvider.GUI_MTR_AVAILABLE.getMutableText(new Object[0]), this.f_96543_ / 2 - 72 - 20, 20, -1);
        graphicsHolder.drawCenteredText(TranslationProvider.GUI_MTR_SELECTED.getMutableText(new Object[0]), this.f_96543_ / 2 + 72 + 20, 20, -1);
    }

    @Override
    public void mouseMoved2(double mouseX, double mouseY) {
        this.availableList.mouseMoved(mouseX, mouseY);
        this.selectedList.mouseMoved(mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        this.availableList.mouseScrolled(mouseX, mouseY, amount);
        this.selectedList.mouseScrolled(mouseX, mouseY, amount);
        return super.mouseScrolled2(mouseX, mouseY, amount);
    }

    @Override
    public void onClose2() {
        super.onClose2();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    protected void updateList() {
        ObjectArrayList<DashboardListItem> availableData = new ObjectArrayList<DashboardListItem>();
        for (DashboardListItem dashboardListItem : this.allData) {
            if (!this.canRepeat && this.selectedIds.contains(dashboardListItem.id)) continue;
            availableData.add(dashboardListItem);
        }
        ObjectArrayList<DashboardListItem> selectedData = new ObjectArrayList<DashboardListItem>();
        LongIterator longIterator = this.selectedIds.iterator();
        while (longIterator.hasNext()) {
            long selectedId = (Long)longIterator.next();
            this.allData.stream().filter(data -> data.id == selectedId).findFirst().ifPresent(selectedData::add);
        }
        this.availableList.setData(availableData, false, false, false, false, true, false);
        this.selectedList.setData(selectedData, false, false, false, this.canRepeat, false, true);
    }

    private void onAdd(DashboardListItem dashboardListItem, int index) {
        if (this.isSingleSelect) {
            this.selectedIds.clear();
        }
        this.selectedIds.add(dashboardListItem.id);
        this.updateList();
    }

    private void onDelete(DashboardListItem dashboardListItem, int index) {
        if (this.canRepeat && this.selectedIds instanceof LongList) {
            ((LongList)this.selectedIds).removeLong(index);
        } else {
            this.selectedIds.rem(dashboardListItem.id);
        }
        this.updateList();
    }
}

