/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.sound;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.ResourceManagerHelper;
import org.mtr.mod.sound.BveConfigFile;
import org.mtr.mod.sound.BveMotorData4;
import org.mtr.mod.sound.BveMotorData5;
import org.mtr.mod.sound.BveMotorDataBase;

public class BveVehicleSoundConfig {
    public final String baseName;
    public final String audioBaseName;
    public final BveConfigFile config;
    public final BveMotorDataBase motorData;

    public BveVehicleSoundConfig(String baseName) {
        Identifier baseLocation = baseName.contains(":") ? new Identifier(baseName) : new Identifier("mtr", baseName);
        this.baseName = baseLocation.toString();
        String configBaseName = baseLocation.getNamespace() + ":sounds/" + baseLocation.getPath();
        this.audioBaseName = baseLocation.getNamespace() + ":" + baseLocation.getPath() + "_";
        this.config = new BveConfigFile(BveVehicleSoundConfig.readResource(new Identifier(configBaseName + "/sound.cfg")), this);
        this.motorData = this.config.motorNoiseDataType == 4 ? new BveMotorData4(configBaseName) : new BveMotorData5(configBaseName);
    }

    public static String readResource(Identifier location) {
        String[] result = new String[]{""};
        ResourceManagerHelper.readResource(location, inputStream2 -> {
            try {
                result[0] = IOUtils.toString((InputStream)inputStream2, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        return result[0];
    }
}

